/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks.rendering;

import java.awt.Shape;
import java.awt.geom.PathIterator;

public class BevelIterator {
    public float[] pt1 = new float[]{0.0f, 0.0f};
    public float[] pt2 = new float[]{0.0f, 0.0f};
    public float[] pt3 = new float[]{0.0f, 0.0f};
    public float[] pt4 = new float[]{0.0f, 0.0f};
    public float[] inset2 = new float[]{0.0f, 0.0f};
    public float[] inset3 = new float[]{0.0f, 0.0f};
    public float[] perpVec = new float[]{0.0f, 0.0f};
    private Shape area;
    private double flatness;
    private PathIterator iter;
    private int progress;
    private float[] currentPoint = new float[]{0.0f, 0.0f};
    private float[] p = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private float[] array = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private float[] v1 = new float[]{0.0f, 0.0f};
    private float[] v2 = new float[]{0.0f, 0.0f};

    public BevelIterator(Shape area, double flatness) {
        this.area = area;
        this.flatness = flatness;
        this.iter = area.getPathIterator(null, flatness);
        this.progress = -2;
        this.doGetPoint();
        this.pt1[0] = this.currentPoint[0];
        this.pt1[1] = this.currentPoint[1];
        this.pathIterAdvance();
        this.pt2[0] = this.currentPoint[0];
        this.pt2[1] = this.currentPoint[1];
        this.pathIterAdvance();
        this.pt3[0] = this.currentPoint[0];
        this.pt3[1] = this.currentPoint[1];
        this.pathIterAdvance();
        this.pt4[0] = this.currentPoint[0];
        this.pt4[1] = this.currentPoint[1];
        this.getInsetVector(this.pt1, this.pt2, this.pt3, this.inset2);
        this.getInsetVector(this.pt2, this.pt3, this.pt4, this.inset3);
        this.getPerpVec(this.pt2, this.pt3, this.perpVec);
    }

    public void nextSegment() {
        if (!this.isDone()) {
            this.pathIterAdvance();
            this.pt1[0] = this.pt2[0];
            this.pt1[1] = this.pt2[1];
            this.pt2[0] = this.pt3[0];
            this.pt2[1] = this.pt3[1];
            this.pt3[0] = this.pt4[0];
            this.pt3[1] = this.pt4[1];
            this.pt4[0] = this.currentPoint[0];
            this.pt4[1] = this.currentPoint[1];
            this.inset2[0] = this.inset3[0];
            this.inset2[1] = this.inset3[1];
            this.getInsetVector(this.pt2, this.pt3, this.pt4, this.inset3);
            this.getPerpVec(this.pt2, this.pt3, this.perpVec);
        }
    }

    public boolean isDone() {
        return this.progress >= 2;
    }

    public float[] insetPoint2(float scalar, float[] f) {
        f[0] = this.pt2[0] + this.inset2[0] * scalar;
        f[1] = this.pt2[1] + this.inset2[1] * scalar;
        return f;
    }

    public float[] insetPoint3(float scalar, float[] f) {
        f[0] = this.pt3[0] + this.inset3[0] * scalar;
        f[1] = this.pt3[1] + this.inset3[1] * scalar;
        return f;
    }

    private void pathIterAdvance() {
        if (this.progress < -1) {
            ++this.progress;
            return;
        }
        this.iter.next();
        if (!this.iter.isDone() && this.iter.currentSegment(this.p) == 4) {
            this.iter.next();
        }
        if (this.iter.isDone()) {
            this.iter = this.area.getPathIterator(null, this.flatness);
            ++this.progress;
        } else if (this.progress >= 0) {
            ++this.progress;
        }
        this.p[0] = this.currentPoint[0];
        this.p[1] = this.currentPoint[1];
        this.doGetPoint();
        if ((double)((this.p[0] - this.currentPoint[0]) * (this.p[0] - this.currentPoint[0]) + (this.p[1] - this.currentPoint[1]) * (this.p[1] - this.currentPoint[1])) < 0.001 && !this.isDone()) {
            this.pathIterAdvance();
        }
    }

    private int doGetPoint() {
        int kind = this.iter.currentSegment(this.array);
        this.currentPoint[0] = this.array[0];
        this.currentPoint[1] = this.array[1];
        return kind;
    }

    private void getInsetVector(float[] pt1, float[] pt2, float[] pt3, float[] out) {
        this.v1[0] = pt1[0] - pt2[0];
        this.v1[1] = pt1[1] - pt2[1];
        this.v2[0] = pt3[0] - pt2[0];
        this.v2[1] = pt3[1] - pt2[1];
        float len = (float)Math.sqrt(this.v1[0] * this.v1[0] + this.v1[1] * this.v1[1]);
        this.v1[0] = this.v1[0] / len;
        this.v1[1] = this.v1[1] / len;
        len = (float)Math.sqrt(this.v2[0] * this.v2[0] + this.v2[1] * this.v2[1]);
        this.v2[0] = this.v2[0] / len;
        this.v2[1] = this.v2[1] / len;
        out[0] = this.v1[0] + this.v2[0];
        out[1] = this.v1[1] + this.v2[1];
        if (out[0] == 0.0f && out[1] == 0.0f) {
            out[0] = -this.v1[1];
            out[1] = this.v1[0];
        } else {
            float scale = 1.0f / (-this.v1[1] * this.v2[0] + this.v1[0] * this.v2[1]);
            out[0] = out[0] * scale;
            out[1] = out[1] * scale;
        }
    }

    private void getPerpVec(float[] pt1, float[] pt2, float[] vec) {
        vec[0] = -(pt2[1] - pt1[1]);
        vec[1] = pt2[0] - pt1[0];
        float len = (float)Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1]);
        vec[0] = vec[0] / len;
        vec[1] = vec[1] / len;
    }
}

